import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

/**
 * Classe che fa una bind e successivamente di una unbnd di un server
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 */
public class TestBindUnbindServer1 {
	public static void main(String []argv){
		//Istanziazione degli stream di output
		ShowMessagePrompt show=new ShowMessagePrompt();
		
		RegistryInfo reg=null;
		int IDUniquePortNum;
		String IDUniqueHost;
		NewsgroupServerImpl server_ref;
		
		if(argv.length!=5){
			show.println("Usage: java TestBindUnbindServer1 <IDUniquehost> <IDUniqueportNum> " +
						"<serverHost> <firstLevPortNum> <secLevPortNum>");
			System.exit(0);
		}
		try{
			//Connessione con il server di nomi univoci
			IDUniqueHost=argv[0];
			IDUniquePortNum=Integer.parseInt(argv[1]);
			String registryURL = "rmi://" +IDUniqueHost+ ":" +IDUniquePortNum+"/IDUnique";
			
			/* recupero riferimento al server IDUnique */
			IIDUnique idUniqueServ=(IIDUnique)Naming.lookup(registryURL);
			show.println("Ottenuto il riferimento al server di nomi univoci" );
			
			//Ottenimento del nome univoco del server da creare
			String curServName=idUniqueServ.nextName("server");
			
			//creazione del RegistryInfo
			reg=new RegistryInfo(Integer.parseInt(argv[3]),Integer.parseInt(argv[4]),argv[2],curServName);
			
			//Preparazione url del server
			registryURL = "rmi://"+reg.getHost()+":"+
						RegistryInfo.secondLevelPortNum+"/"+curServName;
			
			//Controllo che ci sia gi un server attivo.
			Registry rProva=(Registry)LocateRegistry.getRegistry(Integer.parseInt(argv[4]));
			//Se riesco a fare la list ho gi un server attivo che ha creato il secondo registro
			String []servers=rProva.list();
				
			//Cerco un server casuale s a cui chiedere la bind
			ChooseServerRandom serv=new ChooseServerRandom(reg);
			IServer s=null;
			int numTry=0;
			do{		
				/* recupero riferimento al server */
				s=(IServer)rProva.lookup(serv.whichServer());
				numTry++;
			}while((s==null)&&(numTry<(servers.length/2+1)));
				
			//Creazione del riferimento al server
			server_ref = new NewsgroupServerImpl(curServName,idUniqueServ,show,
									TestMsg.getMsg(idUniqueServ,show),false);

			//Faccio il binding
			s.bindService(server_ref,reg);
			show.println("Binding avvenuto con successo.");
			show.println("Newsgroup Server ready.");
			show.println("\n\n");
			
			//Aspetto un poco prima della unbind
			Thread.sleep(3000);
			s.unbindService(server_ref,reg);
			show.println("Unbind eseguita");
			System.exit(3);
			
			
		}
		catch(Exception e){
			show.println("TestBindUnbindServer1 "+e);
			System.exit(1);
		}
	}//end main
	
}
